<?php
function askAI($prompt) {
    $config = json_decode(file_get_contents("config.json"), true);

    $body = [
        "model" => "deepseek-chat",
        "messages" => [
            ["role" => "system", "content" => $config["systemPrompt"]],
            ["role" => "user", "content" => $prompt]
        ]
    ];

    $ch = curl_init("https://api.deepseek.com/v1/chat/completions");
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer " . $config["deepSeekKey"],
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);

    $response = json_decode($res, true);
    return $response['choices'][0]['message']['content'] ?? "⚠️ حدث خطأ أثناء استخدام الذكاء الاصطناعي.";
}
?>
