<?php
include "send.php";
include "ai.php";

$configPath = "config.json";
if (!file_exists($configPath)) {
    http_response_code(500);
    exit("❌ الملف config.json غير موجود.");
}

$config = json_decode(file_get_contents($configPath), true);
if (!is_array($config) || !isset($config['blockedList'])) {
    http_response_code(500);
    exit("❌ إعدادات config.json غير صالحة.");
}

$input = json_decode(file_get_contents("php://input"), true);
$fromFull = $input['actualObj']['remoteJid'] ?? '';
$from = str_replace("@s.whatsapp.net", "", $fromFull);
$text = trim($input['actualObj']['msgContext']['text'] ?? '');

if (!$from || !$text) {
    http_response_code(400);
    exit("❗ لا يوجد محتوى كافٍ للرسالة.");
}
//للفحص و اللوغ
//file_put_contents("log.txt", date("Y-m-d H:i:s") . " | FROM: $from | TEXT: $text\n", FILE_APPEND);

if (in_array($from, $config['blockedList'])) exit;

@mkdir("sessions");
$stateFile = "sessions/$from.json";

if (!file_exists($stateFile)) {
    file_put_contents($stateFile, json_encode(["enabled" => $config['globalAI'], "warned" => false]));
}

$state = json_decode(file_get_contents($stateFile), true);

if (strtolower($text) === "ايقاف") {
    $state['enabled'] = false;
    if (!$state['warned']) {
        sendMessage($from, "🛑 تم إيقاف الذكاء الاصطناعي لهذه المحادثة.");
        $state['warned'] = true;
    }
    file_put_contents($stateFile, json_encode($state));
    exit;
}

if (strtolower($text) === "تشغيل") {
    $state['enabled'] = true;
    $state['warned'] = false;
    sendMessage($from, "✅ تم تفعيل الذكاء الاصطناعي.");
    file_put_contents($stateFile, json_encode($state));
    exit;
}

if ($state['enabled']) {
    $reply = askAI($text);
    sendMessage($from, $reply);
}
?>
