<?php
session_start();

// إعداد كلمة المرور
$password = 'admin';
$username = 'admin';

// عند تسجيل الدخول
if (isset($_POST['login'])) {
    if ($_POST['username'] === $username && $_POST['password'] === $password) {
        $_SESSION['auth'] = true;
        header("Location: panel.php");
        exit;
    } else {
        $error = "❌ اسم المستخدم أو كلمة المرور غير صحيحة";
    }
}

// عند تسجيل الخروج
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: panel.php");
    exit;
}

// التحقق من الجلسة
if (!isset($_SESSION['auth'])):
?>
<!DOCTYPE html>
<html lang="ar">
<head>
  <meta charset="UTF-8">
  <title>تسجيل الدخول - لوحة الذكاء الاصطناعي</title>
  <style>
    body { font-family: sans-serif; background: #0d1117; color: #eee; text-align: center; padding: 100px; }
    input { padding: 10px; width: 250px; margin: 10px; }
    button { padding: 10px 20px; }
    .box { background: #161b22; padding: 40px; border-radius: 10px; display: inline-block; }
  </style>
</head>
<body>
  <div class="box">
    <h2>🔐 دخول لوحة التحكم بالذكاء الاصطناعي</h2>
    <form method="POST">
      <input type="text" name="username" placeholder="اسم المستخدم" required><br>
      <input type="password" name="password" placeholder="كلمة المرور" required><br>
      <button type="submit" name="login">دخول</button>
    </form>
    <?php if (isset($error)) echo "<p style='color:red'>$error</p>"; ?>
  </div>
</body>
</html>
<?php exit; endif; ?>

<?php
$configPath = "config.json";
$config = json_decode(file_get_contents($configPath), true);

if (isset($_POST['save'])) {
    $config['instanceID'] = $_POST['instanceID'];
    $config['token'] = $_POST['token'];
    $config['systemPrompt'] = $_POST['systemPrompt'];
    $config['blockedList'] = array_filter(array_map('trim', explode("\n", $_POST['blockedList'])));
    $config['globalAI'] = isset($_POST['globalAI']);
    file_put_contents($configPath, json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $msg = "✅ تم حفظ التعديلات بنجاح";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
  <meta charset="UTF-8">
  <title>لوحة تحكم الذكاء الاصطناعي</title>
  <style>
    body { font-family: 'Segoe UI', sans-serif; background: #f0f4f8; padding: 40px; color: #333; }
    .container { max-width: 700px; margin: auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    h2 { color: #005a9c; }
    label { font-weight: bold; display: block; margin-top: 15px; }
    textarea, input[type="text"] { width: 100%; padding: 10px; margin-top: 5px; }
    button { padding: 10px 20px; margin-top: 20px; background: #005a9c; color: white; border: none; border-radius: 5px; cursor: pointer; }
    button:hover { background: #003e6d; }
    .logout { float: left; }
  </style>
</head>
<body>
  <div class="container">
    <form method="POST">
      <a class="logout" href="?logout=1">🔓 تسجيل الخروج</a>
      <h2>🧠 لوحة تحكم روبوت الذكاء الاصطناعي - WhatsApp</h2>

      <?php if (isset($msg)) echo "<p style='color: green;'>$msg</p>"; ?>

      <label>📡 Instance ID</label>
      <input type="text" name="instanceID" value="<?=htmlspecialchars($config['instanceID'])?>" required>

      <label>🔑 Token</label>
      <input type="text" name="token" value="<?=htmlspecialchars($config['token'])?>" required>

      <label>🧠 System Prompt</label>
      <textarea name="systemPrompt" rows="3"><?=htmlspecialchars($config['systemPrompt'])?></textarea>

      <label>📵 أرقام مستثناة (رقم في كل سطر)</label>
      <textarea name="blockedList" rows="5"><?=implode("\n", $config['blockedList'])?></textarea>

      <label><input type="checkbox" name="globalAI" <?= $config['globalAI'] ? 'checked' : '' ?>> ✅ تفعيل الذكاء الاصطناعي لجميع المستخدمين</label>

      <button type="submit" name="save">💾 حفظ التعديلات</button>
    </form>
  </div>
</body>
</html>
